Triggers = {}

include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/end_trigger")
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/kill_watcher")

Triggers["center_point"] = 
{
	active = false, 
	effect_radius = 20, 
	position = { x = 90.90, y = 93.63, z = 0, f = 1.0}, 
	priority = 1.0, 
	think = "tf_center_point", 
	type = "quest", 
}

Triggers["check_pass_gate"] = 
{
	active = true, 
	effect_radius = 12, 
	position = { y=117.1, x=91.3, z=-1.4, f=1 }, 
	priority = 1, 
	think = "tf_check_pass_gate", 
	type = "quest", 
}

Triggers["check_pass_hole"] = 
{
	active = true, 
	effect_radius = 12, 
	position = { y=52.6, x=127.7, z=-1.4, f=1 }, 
	priority = 1, 
	think = "tf_check_pass_hole", 
	type = "quest", 
}

Triggers["emergency_exit"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_emergency_exit", 
	type = "quest", 
}

Triggers["on_start"] = 
{
	active = true, 
	effect_radius = 10, 
	position = { x = 129.1, y = 97.2, z = -1.6, f = 1.0}, 
	priority = 1, 
	think = "tf_on_start", 
	type = "quest", 
}

Triggers["patrol_0"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "circle", 
	point_count = 7, 
	point_radius = 1, 
	position = { y=24.4, x=137.7, z=-1.3, f=1 }, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "each", 
	wait_time = 3, 
	patrol_points = {{ x=137.668, y=24.3649, z=-1.33056},{ x=130.525, y=42.4474, z=-1.37754},{ x=109.59, y=42.3096, z=-1.4114},{ x=100.071, y=71.8075, z=-1.36028},{ x=93.3083, y=51.5891, z=-1.19145},{ x=117.536, y=55.5295, z=-1.56421},{ x=119.065, y=25.5688, z=-1.48122} }
}

Triggers["patrol_1"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "circle", 
	point_count = 7, 
	point_radius = 1, 
	position = { y=31.9, x=32.1, z=-0.8, f=1 }, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "random", 
	wait_time = 5, 
	patrol_points = {{ x=32.1427, y=31.9336, z=-0.755383},{ x=35.6453, y=43.651, z=-0.807796},{ x=49.3127, y=47.7188, z=-0.977238},{ x=49.6825, y=61.3947, z=-0.893112},{ x=72.6846, y=88.7155, z=-1.47007},{ x=61.6745, y=111.269, z=-1.32774},{ x=35.6326, y=134.476, z=-1.2348} }
}

Triggers["relations_vs_army"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_relations_vs_army", 
	type = "quest", 
}

trigger_functions =
{
tf_check_pass_gate = function(trigger_id, time)
	local trigger = Triggers[trigger_id]

	if (getGVAR("spawn_patrol_ap") == _YES) then
		if((trigger.active == true) and (ARMY == Sectors.airport.owner) and (relations(ARMY, PLAYER) ~= ENEMY)) then
			checkPointer("airport", trigger_id, {"army_1_off", "army_2",}, "checkpoint_remark1", "checkpoint_remark2", "docu_check", 10, time, true, 30, "checkpoint_remark3", false)
		end
	end
end,
tf_check_pass_hole = function(trigger_id, time)
	local trigger = Triggers[trigger_id]

	if (getGVAR("spawn_patrol_ap") == _YES) then
		if((trigger.active == true) and (ARMY == Sectors.airport.owner) and (relations(ARMY, PLAYER) ~= ENEMY)) then
			checkPointer("airport", trigger_id, {"army_22"}, "checkpoint_remark1", "checkpoint_remark2", "docu_check", 10, time, true, 30, "checkpoint_remark3", false)
		end
	end
end,
tf_emergency_exit = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
--		Sectors.airport.isEscaped = true
		finishMission(false)
		trigger.active = false
	end
end,
tf_on_start = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		--Sectors["airport"].onUpdate()
		trigger.active = false
	end
end,
tf_relations_vs_army = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		changeLocalRelations(ENEMY, ARMY)
		trigger.active = false
	end
end,
--
-- end trigger
--
tf_end_trigger = CommonTriggers.end_trigger,
--
-- kill watcher trigger
--
tf_kill_watcher = CommonTriggers.kill_watcher,
--
-- honey point for bees
--
tf_center_point = CommonTriggers.center_point,
}
